/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.ui.LauncherUtils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.Targetable;
import com.ibm.hwmca.ui.bonsai.servlet.Action;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WPage;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TaskLauncherAction
implements Action {
    public static final String URI = "/hmc/ui/bonsai/launch.do";
    private static final String TRACEMASK_T = "XBUILCHT";
    private static final String TRACEMASK_F = "XBUILCHF";
    private static final String TRACEMASK_D = "XBUILCHD";

    public WPage perform(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response, RenderingContext rc) throws IOException, ServletException {
        Trace.trace(TRACEMASK_T, "--> TaskLauncherAction.perform()");
        try {
            HMCSession hmcSession = HMCSession.getHMCSession(request.getSession());
            LaunchParms parms = new LaunchParms(request, hmcSession);
            Trace.trace(TRACEMASK_D, parms);
            LauncherUtils.getLauncherUtils(hmcSession).launchTask(parms.task, parms.targets, parms.parent, parms.type);
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_F, ex);
        }
        Trace.trace(TRACEMASK_T, "<-- TaskLauncherAction.perform()");
        return null;
    }

    private static class LaunchParms {
        private static Set validTypes = new HashSet();
        int type;
        String task;
        String targets;
        String parent;

        LaunchParms(HttpServletRequest request, HMCSession hmcSession) {
            try {
                Integer typeObj = new Integer(request.getParameter("type"));
                if (typeObj == null) {
                    throw new IllegalArgumentException("'type' was not passed in the request");
                }
                if (!validTypes.contains(typeObj)) {
                    throw new IllegalArgumentException("'type' was not a valid task launch type");
                }
                this.type = typeObj;
            }
            catch (NumberFormatException nfEx) {
                throw new IllegalArgumentException("'type' was not passed as a valid integer");
            }
            this.task = request.getParameter("task");
            if (this.type != 3 && this.task == null) {
                throw new IllegalArgumentException("'task' was not passed in the request");
            }
            this.targets = request.getParameter("targets");
            this.parent = request.getParameter("parent");
            if (this.targets == null && this.type == 2) {
                UserObject userObj = UserObject.getUserObject(hmcSession);
                BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
                if (userObj.isActiveSelectionInTree()) {
                    Targetable node = (Targetable)((Object)treeManager.getTreeNode(userObj.getTreeSelection()));
                    this.targets = node.getShortId();
                    this.parent = node.getParentShortId();
                } else {
                    List nodes = treeManager.getTreeNodes(userObj.getTableSelection());
                    this.targets = this.buildTargetString(nodes);
                    this.parent = ((Targetable)nodes.get(0)).getParentShortId();
                }
            }
        }

        private String buildTargetString(List targets) {
            Iterator i = targets.iterator();
            StringBuffer targetString = new StringBuffer(((Targetable)i.next()).getShortId());
            while (i.hasNext()) {
                targetString.append(" " + ((Targetable)i.next()).getShortId());
            }
            return targetString.toString();
        }

        public String toString() {
            return "task=[" + this.task + "],type=[" + this.type + "],targets=[" + this.targets + "],parent=[" + this.parent + "]";
        }

        static {
            validTypes.add(new Integer(1));
            validTypes.add(new Integer(2));
            validTypes.add(new Integer(3));
            validTypes.add(new Integer(4));
        }
    }
}

